<?php
include "/home/xtreamcodes/iptv_xtream_codes/admin/functions.php";
$bDoBackup = false;
$clearLogs = false;

//do backup
if (isset($rAdminSettings['automatic_backups']) && !empty($rAdminSettings['automatic_backups'])) {
    if ($rAdminSettings['automatic_backups'] == 'hourly' && $rAdminSettings['automatic_backups_check'] < (time() - 3600)) {
        $bDoBackup = true;
    } elseif ($rAdminSettings['automatic_backups'] == 'daily' && $rAdminSettings['automatic_backups_check'] < (time() - 86400)) {
        $bDoBackup = true;
    } elseif ($rAdminSettings['automatic_backups'] == 'weekly' && $rAdminSettings['automatic_backups_check'] < (time() - 604800)) {
        $bDoBackup = true;
    } elseif ($rAdminSettings['automatic_backups'] == 'monthly' && $rAdminSettings['automatic_backups_check'] < (time() - 2592000)) {
        $bDoBackup = true;
    }
}

//clear logs
if (isset($rAdminSettings['clear_log_auto']) && !empty($rAdminSettings['clear_log_auto']) && isset($rAdminSettings['clear_log_older_than_days']) && !empty($rAdminSettings['clear_log_older_than_days']) && isset($rAdminSettings['clear_log_check']) && !empty($rAdminSettings['clear_log_check'])) {
	if(time() > ($rAdminSettings['clear_log_check'] + $rAdminSettings['clear_log_older_than_days'] * 86400)) {
		$clearLogs = true;
	}
}

if ($bDoBackup) {
    $rFilename = MAIN_DIR . "adtools/backups/backup_" . date("Y-m-d_H:i:s") . ".sql";
	$rFilenameGz = MAIN_DIR . "adtools/backups/backup_" . date("Y-m-d_H:i:s") . ".sql.gz";
    $rCommand = "mysqldump -u " . $_INFO["db_user"] . " -p" . $_INFO["db_pass"] . " -P " . $_INFO["db_port"] . " " . $_INFO["db_name"] . " --ignore-table=xtream_iptvpro.user_activity --ignore-table=xtream_iptvpro.stream_logs --ignore-table=xtream_iptvpro.panel_logs --ignore-table=xtream_iptvpro.client_logs --ignore-table=xtream_iptvpro.epg_data > \"" . $rFilename . "\" && gzip -9f \"" . $rFilename . "\"";
    $rRet = shell_exec($rCommand);
    if (file_exists($rFilenameGz)) {
        $rAdminSettings['automatic_backups_check'] = time();
        writeAdminSettings();
        $rBackups = getBackups();
        if ((count($rBackups) > intval($rAdminSettings["backups_to_keep"])) && (intval($rAdminSettings["backups_to_keep"]) > 0)) {
            $rDelete = array_slice($rBackups, 0, count($rBackups) - intval($rAdminSettings["backups_to_keep"]));
            foreach ($rDelete as $rItem) {
				if (file_exists(MAIN_DIR . "adtools/backups/" . $rItem["filename"].".gz")) {
                    unlink(MAIN_DIR . "adtools/backups/" . $rItem["filename"].".gz");
                }
            }
        }
		
		//Send mysql.sql.gz file to Email
		if (isset($rAdminSettings['automatic_backups_email']) && !empty($rAdminSettings['automatic_backups_email'])) {
			sendBackupEmail($rFilenameGz);
		}
    }
}

if ($clearLogs) {
	$rTables = $rAdminSettings["clear_log_tables"];
	$rTables = json_decode($rTables, True);
	if(!empty($rTables))
	{
		foreach($rTables as $rTable)
		{
			call_user_func($rTable);
		}
		
		$rAdminSettings['clear_log_check'] = time();
		writeAdminSettings();
	}
}

